﻿using System;

namespace Smartling.Connector.sitecore_modules.Shell.Smartling.Connector
{
  using System.Text;

  using global::Smartling.Connector.Model;

  public partial class Audit : System.Web.UI.Page
  {
    protected void Page_Load(object sender, EventArgs e)
    {
      this.UpdateMessages();
    }

    private void UpdateMessages()
    {
      var sb = new StringBuilder();
      foreach (var message in AuditTrail.GetAllMessages())
      {
        sb.Append(
          "<span data-localtime-format class=\"label localtime label-" + message.Label + "\">" + string.Concat(message.Created.ToString("s"), "Z") + "</span> "
          + message.Message + "<br>");
      }

      this.Messages.Text = sb.ToString();
    }

    protected void AuditTimer_Tick(object sender, EventArgs e)
    {
      this.UpdateMessages();
    }
  }
}